# Q[ϐW[
# Author:: fukuyama
# Date:: 2009/12/30
# Copyright:: Copyright (c) 2005-2009 rgss-lib

module Variables
  module_function

  # ϐ񏀔
  $_variables_idmap = Hash.new(-1.freeze)
  Data_Loader.data_system.variables.each_with_index do |key,index|
    unless key.nil? or key.empty?
      $_variables_idmap[key] = index
    end
  end

  # key ̕ϐ擾
  def []( key, default = nil )
    id = normarize_id(key)
    if id < 0
      return default
    end
    return $game_variables[id]
  end

  # key ̕ϐvalɂ
  def []=( key, val )
    id = normarize_id(key)
    if id < 0
      return nil
    end
    return $game_variables[id] = val
  end

  # key ϐ݊mF
  def include?(key)
    return $_variables_idmap.include?(key)
  end

  def exist?(key)
    return include?(key)
  end

  def member?(key)
    return include?(key)
  end

  # key ϐCfbNX擾
  def index(key)
    return $_variables_idmap[key]
  end

  # IDNAMẼXCb`𐳋K
  def normarize_id(id_or_name)
    case id_or_name
    when Integer
      return id_or_name
    when String
      return index(id_or_name)
    end
    return -1
  end
end
